class X2Effect_NovaShieldEffect extends X2Effect_ModifyStats;

var int ShieldRemoval;

//minor reave is 1, 50, 0, 0 
protected simulated function OnEffectAdded(const out EffectAppliedData ApplyEffectParameters, XComGameState_BaseObject kNewTargetState, XComGameState NewGameState, XComGameState_Effect NewEffectState)
{
	local StatChange			ShieldHPChange;
	local XComGameState_Unit	Caster;
	local XComGameState_Item	SourceItem;

	ShieldHPChange.StatType = eStat_ShieldHP;

	Caster = XComGameState_Unit (NewGameState.GetGameStateForObjectID(ApplyEffectParameters.SourceStateObjectRef.ObjectID));
    if(Caster == none)
    {
        Caster = XComGameState_Unit(class'XComGameStateHistory'.static.GetGameStateHistory().GetGameStateForObjectID(ApplyEffectParameters.SourceStateObjectRef.ObjectID));
    }

	ShieldHPChange.StatAmount = ShieldRemoval;


	if(Caster.GetCurrentStat(eStat_ShieldHP) <= 0) //past a point, they can't lose any more
	{
		ShieldHPChange.StatAmount = 0;
	}
		
	NewEffectState.StatChanges.AddItem(ShieldHPChange);

	super.OnEffectAdded(ApplyEffectParameters, kNewTargetState, NewGameState, NewEffectState);
}
